/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import adql.db.DefaultDBTable;
import cds.aladin.ForeignKeyColumn;
import cds.aladin.Glu;
import cds.aladin.ServerObsTap;
import cds.aladin.TapTableColumn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TapTable {
    private String schema_name;
    private String table_name;
    private String table_type;
    private String description;
    private String utype;
    private Vector<TapTableColumn> columns;
    public Map<String, TapTableColumn> flaggedColumns;
    public Map<String, String> obsCoreColumns;
    public static final int MAXOBSCORECOLSCOUNTED = 6;
    public List<ForeignKeyColumn> foreignKeyColumns;
    public String alias;

    public synchronized void parseUcds(TapTableColumn column) {
        String ucd = column.getUcd();
        if (ucd != null && !ucd.isEmpty()) {
            if ((ucd = ucd.toLowerCase()).startsWith("pos.eq.ra") || ucd.equalsIgnoreCase("pos_eq_ra_main")) {
                this.setFlaggedColumn("ra", column);
            } else if (ucd.startsWith("pos.eq.dec") || ucd.equalsIgnoreCase("pos_eq_dec_main")) {
                this.setFlaggedColumn("dec", column);
            } else if (ucd.startsWith("pos.parallax")) {
                this.setFlaggedColumn("parallax", column);
            } else if (ucd.startsWith("spect.dopplerveloc")) {
                this.setFlaggedColumn("radialvelocity", column);
            } else if (ucd.equals("meta.bib.bibcode")) {
                this.setFlaggedColumn("bibCode", column);
            } else if (ucd.equals("meta.bib.journal")) {
                this.setFlaggedColumn("journal", column);
            } else if (ucd.equals("meta.title")) {
                this.setFlaggedColumn("title", column);
            } else if (ucd.startsWith("pos.pm;pos.eq.ra")) {
                this.setFlaggedColumn("pmra", column);
            } else if (ucd.startsWith("pos.pm;pos.eq.dec")) {
                this.setFlaggedColumn("pmdec", column);
            } else if (ucd.startsWith("meta.id")) {
                this.setFlaggedColumn("id", column);
            } else if (ucd.contains("src.redshift")) {
                this.setFlaggedColumn("redshift", column);
            } else if (ucd.startsWith("phot.flux")) {
                this.setFlaggedColumn("mag", column);
            }
        }
    }

    public boolean hasObscoreInTheName() {
        boolean result = false;
        Pattern pattern = Pattern.compile("obscore", 2);
        Matcher matcher = pattern.matcher(this.table_name);
        if (matcher.find()) {
            result = true;
        }
        return result;
    }

    public boolean isObscore() {
        boolean result = false;
        if (this.hasObscoreInTheName() && this.obsCoreColumns != null && this.obsCoreColumns.size() > 6) {
            result = true;
        }
        return result;
    }

    public void initObsCoreColumns() {
        if (this.obsCoreColumns == null) {
            this.obsCoreColumns = new HashMap<String, String>();
        }
    }

    public String getFullyQualifiedTableName(String schemaNameAsInSchema, String tableNameAsInSchema) {
        String tableName = null;
        if (tableNameAsInSchema != null) {
            if (schemaNameAsInSchema != null) {
                tableName = schemaNameAsInSchema + ".";
            }
            tableName = tableName != null ? tableName + tableNameAsInSchema : tableNameAsInSchema;
        }
        if (tableName != null) {
            DefaultDBTable table = new DefaultDBTable(tableName);
            if (table.getADQLSchemaName() != null) {
                tableName = table.getADQLSchemaName() + ".";
            }
            if (table.getADQLName() != null) {
                tableName = tableName + table.getADQLName();
            }
        }
        return tableName;
    }

    public String getFullyQualifiedTableName() {
        return this.getFullyQualifiedTableName(this.schema_name, this.table_name);
    }

    public String getFullyQualifiedTableName(String tableNameInput) {
        return this.getFullyQualifiedTableName(this.schema_name, tableNameInput);
    }

    public String getAdqlName() {
        DefaultDBTable table;
        String adqlName = null;
        if (this.table_name != null && (table = new DefaultDBTable(this.table_name)).getADQLName() != null) {
            adqlName = table.getADQLName();
        }
        return adqlName;
    }

    public static String getQueryPart1(String queryPartInput) {
        Pattern regex;
        Matcher matcher;
        if (queryPartInput != null && (matcher = (regex = Pattern.compile("[$&+,:;=?@#/\\\\|]")).matcher(queryPartInput)).find()) {
            queryPartInput = Glu.doubleQuote(queryPartInput);
        }
        return queryPartInput;
    }

    public static String getQueryPart(String queryPartInput, boolean isForTableName) {
        Pattern regex;
        Matcher matcher;
        if (queryPartInput != null && !(matcher = (regex = Pattern.compile("^(?<tableName>[\\p{L}_][\\p{L}\\p{N}@$#_]{0,127})$")).matcher(queryPartInput)).find()) {
            if (!isForTableName) {
                queryPartInput = Glu.doubleQuote(queryPartInput);
            } else {
                String prefix = "";
                String potentialTableName = queryPartInput;
                Pattern prefixPattern = Pattern.compile("^(?<prefix>(?<tableName>[\\p{L}_][\\p{L}\\p{N}@$#_]{0,127})?\\.)");
                matcher = prefixPattern.matcher(queryPartInput);
                if (matcher.find()) {
                    prefix = matcher.group("prefix");
                    potentialTableName = queryPartInput.replaceFirst(prefix, "");
                }
                if (!(matcher = regex.matcher(potentialTableName)).find() && TapTable.isUnQuotedPattern(potentialTableName)) {
                    queryPartInput = Glu.doubleQuote(potentialTableName);
                    queryPartInput = prefix + queryPartInput;
                }
            }
        }
        return queryPartInput;
    }

    public static boolean isUnQuotedPattern(String input) {
        boolean result = true;
        Pattern isQuotedPattern = Pattern.compile("^\"[^\"]+\"$");
        Matcher isQuotedMatcher = isQuotedPattern.matcher(input);
        if (isQuotedMatcher.find()) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseForObscore(boolean isUpload, TapTableColumn columnMeta) {
        if (isUpload || this.hasObscoreInTheName()) {
            this.initObsCoreColumns();
            int mandatoryColumnCount = 0;
            String name = columnMeta.getColumn_name();
            String utype = columnMeta.getUtype();
            if (name == null && utype == null) {
                return;
            }
            if (name == null) {
                name = "";
            }
            utype = utype == null ? "" : this.getNoNamesSpaceUtype(utype);
            Map<String, String> map = this.obsCoreColumns;
            synchronized (map) {
                if (utype.equalsIgnoreCase("ObsDataset.dataProductType") || name.equalsIgnoreCase("dataproduct_type")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("dataproduct_type", name);
                } else if (utype.equalsIgnoreCase("DataID.observationID") || name.equalsIgnoreCase("obs_id")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("obs_id", name);
                } else if (utype.equalsIgnoreCase("Access.reference") || name.equalsIgnoreCase("access_url")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("access_url", name);
                } else if (utype.equalsIgnoreCase("Access.format") || name.equalsIgnoreCase("access_format")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("access_format", name);
                } else if (utype.equalsIgnoreCase("Access.size") || name.equalsIgnoreCase("access_estsize")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("access_estsize", name);
                } else if (utype.equalsIgnoreCase("Char.SpatialAxis.Coverage.Location.Coord.Position2D.Value2.C1") || name.equalsIgnoreCase("s_ra")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("ra", name);
                } else if (utype.equalsIgnoreCase("Char.SpatialAxis.Coverage.Location.Coord.Position2D.Value2.C2") || name.equalsIgnoreCase("s_dec")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("dec", name);
                } else if (utype.equalsIgnoreCase("Char.SpatialAxis.Coverage.Support.Area") || name.equals("s_region")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put(ServerObsTap.FIELDSIZE, name);
                } else if (utype.equalsIgnoreCase("Char.SpatialAxis.Resolution.refval") || name.equalsIgnoreCase("s_resolution")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put(ServerObsTap.SPATIALRESOLUTION, name);
                } else if (utype.equalsIgnoreCase("Char.TimeAxis.Coverage.Bounds.Limits.StartTime") || name.equalsIgnoreCase("t_min")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("t_min", name);
                } else if (utype.equalsIgnoreCase("Char.TimeAxis.Coverage.Bounds.Limits.StopTime") || name.equalsIgnoreCase("t_max")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("t_max", name);
                } else if (utype.equalsIgnoreCase("Char.TimeAxis.Coverage.Support.Extent") || name.equalsIgnoreCase("t_exptime")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put(ServerObsTap.EXPOSURETIME, name);
                } else if (utype.equalsIgnoreCase("Char.TimeAxis.Resolution.Refval.valueResolution.Refval.value") || name.equalsIgnoreCase("t_resolution")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put(ServerObsTap.TIMERESOLUTION, name);
                } else if (utype.equalsIgnoreCase("Char.SpectralAxis.Coverage.Bounds.Limits.LoLimit") || name.equalsIgnoreCase("em_min")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("em_min", name);
                } else if (utype.equalsIgnoreCase("Char.SpectralAxis.Coverage.Bounds.Limits.HiLimit") || name.equalsIgnoreCase("em_max")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put("em_max", name);
                } else if (utype.equalsIgnoreCase("Char.SpectralAxis.Resolution.Refval.value") || name.equalsIgnoreCase("em_res")) {
                    this.obsCoreColumns.put(ServerObsTap.SPECTRALRESOLUTION, name);
                } else if (utype.equalsIgnoreCase("Char.SpectralAxis.Resolution.ResolPower.refVal") || name.equalsIgnoreCase("em_res_power")) {
                    ++mandatoryColumnCount;
                    this.obsCoreColumns.put(ServerObsTap.SPECTRALRESOLUTIONPOWER, columnMeta.getColumn_name());
                }
            }
        }
    }

    private String getNoNamesSpaceUtype(String utype) {
        String result = utype;
        if (utype.startsWith("obscore:")) {
            result = result.replace("obscore:", "");
        }
        return result;
    }

    public void compareAddMainFlaggedColumn(Map<String, TapTableColumn> flaggedColumns, String key, TapTableColumn col2) {
        TapTableColumn col1 = flaggedColumns.get(key);
        if (!col1.isDefinedMain() && col2.isDefinedMain()) {
            flaggedColumns.put(key, col2);
        }
    }

    public void setFlaggedColumn(String key, TapTableColumn flaggedColumn) {
        this.initFlaggedColumns();
        if (this.flaggedColumns.containsKey(key)) {
            this.compareAddMainFlaggedColumn(this.flaggedColumns, key, flaggedColumn);
        } else {
            this.flaggedColumns.put(key, flaggedColumn);
        }
    }

    public void removeFlaggedColumn(String key) {
        this.initFlaggedColumns();
        if (this.flaggedColumns.containsKey(key)) {
            this.flaggedColumns.remove(key);
        }
    }

    public String getFlaggedColumnName(String key, boolean withAlias) {
        String result = null;
        TapTableColumn column = this.getFlaggedColumn(key);
        if (column != null) {
            result = this.flaggedColumns.get(key).getColumnNameForQuery();
            if (withAlias && this.alias != null) {
                result = this.alias + "." + result;
            }
        }
        return result;
    }

    public TapTableColumn getFlaggedColumn(String key) {
        TapTableColumn result = null;
        if (this.flaggedColumns != null && this.flaggedColumns.containsKey(key)) {
            result = this.flaggedColumns.get(key);
        }
        return result;
    }

    public String getObsColumnNameForQuery(String key) {
        String result = this.getObsColumnName(key);
        if (result != null) {
            result = TapTable.getQueryPart(result, false);
        }
        return result;
    }

    public String getObsColumnName(String key) {
        String result = null;
        if (this.obsCoreColumns != null && this.obsCoreColumns.containsKey(key)) {
            result = this.obsCoreColumns.get(key);
        }
        return result;
    }

    public String getRaColumnName(boolean withAlias) {
        return this.getFlaggedColumnName("ra", withAlias);
    }

    public String getDecColumnName(boolean withAlias) {
        return this.getFlaggedColumnName("dec", withAlias);
    }

    public void setRaColumn(TapTableColumn flaggedColumn) {
        if (flaggedColumn == null) {
            this.removeFlaggedColumn("ra");
        } else {
            this.initFlaggedColumns();
            this.flaggedColumns.put("ra", flaggedColumn);
        }
    }

    public void setDecColumn(TapTableColumn flaggedColumn) {
        if (flaggedColumn == null) {
            this.removeFlaggedColumn("dec");
        } else {
            this.initFlaggedColumns();
            this.setFlaggedColumn("dec", flaggedColumn);
        }
    }

    public String getSchema_name() {
        return this.schema_name;
    }

    public void setSchema_name(String schema_name) {
        this.schema_name = schema_name;
    }

    public String getTable_name() {
        return this.table_name;
    }

    public void setTable_name(String table_name) {
        this.table_name = table_name;
    }

    public String getTable_type() {
        return this.table_type;
    }

    public void setTable_type(String table_type) {
        this.table_type = table_type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String utype) {
        this.utype = utype;
    }

    public Vector<TapTableColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Vector<TapTableColumn> columns) {
        this.columns = columns;
    }

    public Map<String, TapTableColumn> getFlaggedColumns() {
        return this.flaggedColumns;
    }

    public void initFlaggedColumns() {
        if (this.flaggedColumns == null) {
            this.flaggedColumns = new HashMap<String, TapTableColumn>();
        }
    }

    public void setFlaggedColumns(Map<String, TapTableColumn> flaggedColumns) {
        this.flaggedColumns = flaggedColumns;
    }

    public Map<String, String> getObsCoreColumns() {
        return this.obsCoreColumns;
    }

    public void setObsCoreColumns(Map<String, String> obsCoreColumns) {
        this.obsCoreColumns = obsCoreColumns;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

